<?php

class Vamtam_Regenerate_Thumbnails extends WP_Background_Process {

	/**
	 * @var string
	 */
	protected $action = 'vamtam_generate_thumbnails';

	private function log( $message ) {
		error_log( $message );
	}

	/**
	 * Generate thumbnails for each imported image
	 * @return false
	 */
	protected function task( $attachment_id ) {
		if ( ! function_exists( 'wp_generate_attachment_metadata' ) ) {
			include ABSPATH . 'wp-admin/includes/image.php';
		}

		$new_metadata = wp_generate_attachment_metadata( $attachment_id, get_attached_file( $attachment_id ) );

		$message = 'VAMTAM -- updating attachment ' . $attachment_id . get_attached_file( $attachment_id ) . " \n ";
		$message .='result: ' . (int)wp_update_attachment_metadata( $attachment_id, $new_metadata );

		$this->log( $message );

		return false;
	}

	protected function complete() {
		parent::complete();
	}
}